"""
Configuración global de RestaurantAI Pro
© 2026 Roberto Martín Gutiérrez & Inés Fraile Verdugo
"""

APP_NAME = "Convastro"
APP_VERSION = "1.1.0"
APP_SUBTITLE = "Inteligencia Financiera para tu Restaurante"

AUTHOR_1 = "Roberto Martín Gutiérrez"
AUTHOR_1_TITLE = "Ingeniero Biomédico - Universidad de Valladolid"
AUTHOR_2 = "Inés Fraile Verdugo"
AUTHOR_2_TITLE = "Especialista en Hostelería - IES Diego de Praves"
YEAR = "2026"
CONTACT_EMAIL = "convderover@gmail.com"
CONTACT_PHONE = "+34 688 942 203"

COLORS = {
    "bg_dark": "#1a1a2e", "bg_medium": "#16213e", "bg_light": "#0f3460",
    "accent": "#e94560", "accent_hover": "#ff6b81",
    "gold": "#d4a574", "gold_light": "#e8c9a0",
    "text_white": "#ffffff", "text_light": "#b8c5d6", "text_muted": "#6b7b8d",
    "success": "#2ecc71", "warning": "#f39c12", "danger": "#e74c3c",
    "card_bg": "#1e2a3a", "card_border": "#2a3a4a",
    "input_bg": "#0d1b2a", "input_border": "#1b2838",
    "sidebar_bg": "#0d1117", "sidebar_hover": "#161b22",
}

DEMO_LIMITS = {
    "max_platos": 10, "max_meses": 3,
    "menu_engineering": True, "analisis_demanda": False,
    "analisis_largo_plazo": False, "chatbot": False,
    "export_pdf": False, "export_excel": False,
    "prediccion_ia": False, "benchmarking": False,
    "whatif": False, "tendencias": False,
}

PRO_FEATURES = {
    "max_platos": 999, "max_meses": 120,
    "menu_engineering": True, "analisis_demanda": True,
    "analisis_largo_plazo": True, "chatbot": True,
    "export_pdf": True, "export_excel": True,
    "prediccion_ia": True, "benchmarking": True,
    "whatif": True, "tendencias": True,
}

REF_MATERIA_PRIMA = 0.38
REF_PERSONAL = 0.30
REF_GASTOS_GENERALES = 0.12
IVA_HOSTELERIA = 0.10

MENU_CATEGORIES = {
    "estrella": {"label": "⭐ Estrella", "desc": "Alta popularidad + Alto margen", "color": "#2ecc71", "action": "Mantener y promocionar"},
    "vaca": {"label": "🐄 Vaca", "desc": "Alta popularidad + Bajo margen", "color": "#f39c12", "action": "Subir precio o reducir coste"},
    "puzzle": {"label": "🧩 Puzzle", "desc": "Baja popularidad + Alto margen", "color": "#3498db", "action": "Promocionar más o reposicionar"},
    "perro": {"label": "🐕 Perro", "desc": "Baja popularidad + Bajo margen", "color": "#e74c3c", "action": "Eliminar o reformular"},
}

# Benchmarks del sector por tipo de restaurante
BENCHMARKS = {
    "tradicional": {"pct_mp": 35, "pct_personal": 30, "pct_gastos": 15, "margen_neto": 12, "ticket_medio": 18, "rotacion_stock": 30},
    "fast food": {"pct_mp": 30, "pct_personal": 25, "pct_gastos": 18, "margen_neto": 15, "ticket_medio": 10, "rotacion_stock": 50},
    "gastronómico": {"pct_mp": 38, "pct_personal": 35, "pct_gastos": 12, "margen_neto": 8, "ticket_medio": 45, "rotacion_stock": 25},
    "bufé": {"pct_mp": 32, "pct_personal": 28, "pct_gastos": 18, "margen_neto": 14, "ticket_medio": 15, "rotacion_stock": 45},
    "cafetería": {"pct_mp": 28, "pct_personal": 32, "pct_gastos": 15, "margen_neto": 18, "ticket_medio": 8, "rotacion_stock": 40},
    "delivery": {"pct_mp": 32, "pct_personal": 20, "pct_gastos": 22, "margen_neto": 10, "ticket_medio": 14, "rotacion_stock": 55},
}
